/*
 * Decompiled with CFR 0.152.
 */
package com.skloch.game.gamelogic;

import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.skloch.game.screens.GameScreen;

public class Time {
    public float daySeconds = 0.0f;
    public int day = 1;
    public Label timeLabel;
    public Label dayLabel;
    public int hoursStudied;
    public int hoursRecreational;
    public int hoursSlept;
    private final GameScreen game;

    public Time(GameScreen game) {
        this.game = game;
    }

    public static String formatTime(int seconds) {
        int hour = Math.floorDiv(seconds, 60);
        String minutes = String.format("%02d", seconds - hour * 60);
        if (hour == 24 || hour == 0) {
            return String.format("12:%sam", minutes);
        }
        if (hour == 12) {
            return String.format("12:%spm", minutes);
        }
        if (hour > 12) {
            return String.format("%d:%spm", hour - 12, minutes);
        }
        return String.format("%d:%sam", hour, minutes);
    }

    public String getMeal() {
        int hours = Math.floorDiv((int)this.daySeconds, 60);
        if (hours >= 7 && hours <= 10) {
            return "breakfast";
        }
        if (hours > 10 && hours <= 16) {
            return "lunch";
        }
        if (hours > 16 && hours <= 21) {
            return "dinner";
        }
        return "food";
    }

    public void passTime(float delta) {
        this.daySeconds += delta;
        while (this.daySeconds >= 1440.0f) {
            this.daySeconds -= 1440.0f;
            ++this.day;
            this.game.updateDay(this.dayLabel, String.format("Day %s", this.day));
        }
        if (this.day >= 8 && this.daySeconds >= 480.0f) {
            this.game.gameOver();
        }
    }

    public void addSleptHours(int hours) {
        this.hoursSlept += hours;
    }

    public void addStudyHours(int hours) {
        this.hoursStudied += hours;
    }

    public void addRecreationalHours(int hours) {
        this.hoursRecreational += hours;
    }

    public String getWakeUpMessage() {
        int daysLeft = 8 - this.day;
        if (daysLeft != 1) {
            return String.format("You have %d days left until your exam!\nRemember to eat, study and have fun, but don't overwork yourself!", daysLeft);
        }
        return "Your exam is tomorrow! I hope you've been studying! Remember not to overwork yourself and get enough sleep!";
    }

    public float getSeconds() {
        return this.daySeconds;
    }
}

